<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Recommendation extends Model 
{

    protected $table = 'recommendations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('enterprise', 'title', 'comment', 'author_id', 'profile_id');

    public function author()
    {
        return $this->belongsTo('App\Models\User', 'author_id');
    }

}